package unipotsdam.informatikkiste;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

/**
 * TODO: document your custom view class.
 */
public class RiddleIdView extends View implements View.OnTouchListener {

    private Path p0, p1, p2, p3, p4, p5, p6;
    private Paint paintActive, paintInActive;
    private boolean[] value;
    private boolean touchEnabled;
    private boolean touchMeSequence;
    private Bitmap bmp, hand;

    public RiddleIdView(Context context) {
        super(context);
        init(null, 0);
    }

    public RiddleIdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(attrs, 0);
    }

    public RiddleIdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    /**
     * @return the id, setted by this view
     */
    public int getRiddleId(){
        int toReturn = 0;
        for(int i = 0; i < value.length; i++) {
            if (value[i]) {
                toReturn = toReturn + (int) Math.pow(2, i);
            }
        }
        return toReturn;
    }

    /**
     * @param id the desired id - has to be a value from 0-127
     */
    public void setRiddleId(int id){
        id = id+1;
        id = id % (int)Math.pow(2,value.length);
        for(int i = value.length-1; i >= 0; i--){
            value[i] = id > (int)Math.pow(2,i);
            if(value[i]){
                id = id - (int)Math.pow(2,i);
            }
        }
        this.invalidate();
    }

    /**
     * Sets, if the view should react to the touch on the screen. Is true by default.
     * @param enableTouch
     */
    public void setTouchEnabled(boolean enableTouch){
        this.touchEnabled = enableTouch;
    }

    private void init(AttributeSet attrs, int defStyle) {
        value = new boolean[7];
        this.setRiddleId((int)(127*Math.random()));

        this.touchEnabled = true;
        this.setOnTouchListener(this);

        bmp = BitmapFactory.decodeResource(getResources(),R.drawable.overlay_1000px);
        hand = BitmapFactory.decodeResource(getResources(),R.drawable.cursor);

        paintActive = new Paint();
        paintActive.setStyle(Paint.Style.FILL);
        paintActive.setColor(getResources().getColor(R.color.colorID_active));
        paintInActive = new Paint();
        paintInActive.setStyle(Paint.Style.FILL);
        paintInActive.setColor(getResources().getColor(R.color.colorID_inactive));

        p0 = new Path();
        p0.moveTo(4,4);
        p0.lineTo(4,3);
        p0.lineTo(3,3);
        p0.lineTo(3,4);
        p0.close();

        p1 = new Path();
        p1.moveTo(3,3);
        p1.lineTo(4,2);
        p1.lineTo(5,3);
        p1.close();

        p2 = new Path();
        p2.moveTo(2,2);
        p2.lineTo(4,2);
        p2.lineTo(2,4);
        p2.close();

        p3 = new Path();
        p3.moveTo(3,1);
        p3.lineTo(5,1);
        p3.lineTo(6,2);
        p3.lineTo(2,2);
        p3.close();

        p4 = new Path();
        p4.moveTo(2,0);
        p4.lineTo(3,1);
        p4.lineTo(1,3);
        p4.lineTo(0,2);
        p4.close();

        p5 = new Path();
        p5.moveTo(2,0);
        p5.lineTo(6,0);
        p5.lineTo(5,1);
        p5.lineTo(3,1);
        p5.close();

        p6 = new Path();
        p6.moveTo(0,0);
        p6.lineTo(2,0);
        p6.lineTo(0,2);
        p6.close();
    }

    private void invalidateMeasurements() {

    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec){
        int size = Math.min(MeasureSpec.getSize(widthMeasureSpec),MeasureSpec.getSize(heightMeasureSpec));
        int width = MeasureSpec.makeMeasureSpec(size,MeasureSpec.EXACTLY);
        int height = MeasureSpec.makeMeasureSpec(size,MeasureSpec.EXACTLY);
        setMeasuredDimension(width,height);
    }

    private Paint getPaint(boolean active){
        if(active) return this.paintActive;
        else return this.paintInActive;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            setLayerType(LAYER_TYPE_SOFTWARE, null);
        }
        super.onDraw(canvas);
        canvas.save();
        canvas.scale(this.getWidth()/8f,this.getHeight()/8f);
        DrawFilter df = new DrawFilter();
        canvas.setDrawFilter(new DrawFilter());

        for(int i = 0; i < 4; i++){
            //canvas.drawPaint(paintActive);
            canvas.rotate(i*90,4,4);

            canvas.drawPath(p0,getPaint(value[0]));
            canvas.drawPath(p1,getPaint(value[1]));
            canvas.drawPath(p2,getPaint(value[2]));
            canvas.drawPath(p3,getPaint(value[3]));
            canvas.drawPath(p4,getPaint(value[4]));
            canvas.drawPath(p5,getPaint(value[5]));
            canvas.drawPath(p6,getPaint(value[6]));
        }

        canvas.restore();
        canvas.drawBitmap(bmp,null,new Rect(0,0,this.getWidth(),this.getHeight()),null);

        if(this.touchMeSequence){
            //812x1280 //TODO harcoded resolution remove
            float handScale = 0.5f;
            int height = (int)(this.getWidth()*handScale);
            int width =  height;
            int x = (this.getWidth()/2 - width/2);
            int y = (this.getHeight()/2 - height/2);
            canvas.drawBitmap(hand,null, new Rect(x,y,(int)width,(int)height),null);
        }
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        if(!(event.getAction() == MotionEvent.ACTION_DOWN)) return true;
        if(!touchEnabled) return true;
        this.touchMeSequence = false;
        float[] p = {event.getX(),event.getY()};
        Matrix m = new Matrix();
        m.setScale(8f/this.getWidth(),8f/this.getHeight());
        m.mapPoints(p);
        float angle = 0;
        if(p[0]>4){
            if(p[1]>4) angle = 180;
            else angle = -90;
        }
        else if(p[1]>4) angle = 90;

        m.reset();
        m.setRotate(angle,4f,4f);
        m.mapPoints(p);
 //       Log.d("Koffer", "After Rotation:  x=" + p[0] + " | y="+p[1]);

        int touchedRegion = 0;

        if(p[0]>3 && p[1]>3){//musst be #1
            touchedRegion = 0;
        }
        else if(p[0] >2 && p[1] > 2){ //musst be #2 or #3
            if(p[0]+p[1] > 6){ //musst be #2
                touchedRegion = 1;
            }
            else{ //musst be #3
                touchedRegion = 2;
            }
        }
        else if(p[0]>1 && p[1]>1){//musst be #4 or #5
            if(p[0]+p[1]>4){//musst be #4
                touchedRegion = 3;
            }
            else{//musst be #5
                touchedRegion = 4;
            }
        }
        else if(p[0]+p[1]<2){//musst be #7
            touchedRegion = 6;
        }
        else if(Math.abs(p[0]-p[1])>2){//musst be #6
            touchedRegion = 5;
        }
        else{ //musst be #5
            touchedRegion = 4;
        }

        this.value[touchedRegion] = !this.value[touchedRegion];
        this.invalidate();
//        Log.d("Koffer","ID: " + this.getRiddleId());
        return true;
    }

    public void setBackgroundColor(int backgroundColor){
        paintActive.setColor(backgroundColor);
        this.invalidate();
    }

    public void resetBackgroundColor(){
        paintActive.setColor(getResources().getColor(R.color.colorID_active));
        this.invalidate();
    }

    //The View shows the user it wants to be touched
    public void activateTouchMeSequence(){
        this.touchMeSequence = true;
        this.invalidate();
    }
}
